<?php
date_default_timezone_set('Africa/Cairo');

$log_file = __DIR__ . '/debug_ycloud.txt';
function log_ycloud($label, $data, $raw_response = null) {
    global $log_file;
    $time = date('Y-m-d H:i:s');
    $log_entry = "$time | $label:\n" . (is_string($data) ? $data : json_encode($data, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
    if ($raw_response !== null) { 
        $log_entry .= "\nRaw Response:\n" . (is_string($raw_response) ? $raw_response : json_encode($raw_response, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT)); 
    }
    file_put_contents($log_file, $log_entry . "\n\n", FILE_APPEND);
}

// ===== إعدادات الاتصال =====
$sb_token     = '2572d8bb6ce1adfccb826aa7888030aac35a1fc9';
$ycloud_token = '7967d732fb3230656e22f2f4993b4c58';
$ycloud_from  = 'whatsapp:1538330937544256';
$sb_api_url   = 'https://abc0123.com/include/api.php';
$secret_key   = 'ycloud123';

$raw = file_get_contents('php://input');
if (!$raw) { http_response_code(200); exit; }

log_ycloud('RAW INPUT', $raw);
$data = json_decode($raw, true);

// ======================================================================
// 1️⃣ استقبال رسالة من YCloud → إرسالها لـ Support Board
// ======================================================================
if (isset($data['type']) && $data['type'] === 'whatsapp.inbound_message.received') {
    $msg = $data['whatsappInboundMessage'];
    $message_text = $msg['text']['body'] ?? '';
    $from_whatsapp_number = $msg['from'] ?? '';
    $name = $msg['customerProfile']['name'] ?? 'WhatsApp User';

    if (empty($from_whatsapp_number) || empty($message_text)) { http_response_code(200); exit; }

    $user_id = null;
    $search_payload = [
        'token' => $sb_token,
        'function' => 'get-user-by',
        'by' => 'phone',
        'value' => $from_whatsapp_number
    ];
    $ch = curl_init($sb_api_url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => $search_payload
    ]);
    $search_resp = curl_exec($ch);
    curl_close($ch);
    $search_data = json_decode($search_resp, true);

    if (!empty($search_data['response']['id'])) {
        $user_id = $search_data['response']['id'];
    } else {
        $extra_json = json_encode(['phone' => [$from_whatsapp_number, 'Phone']]);
        $create_payload = [
            'token' => $sb_token,
            'function' => 'add-user',
            'first_name' => $name,
            'extra' => $extra_json
        ];
        $ch = curl_init($sb_api_url);
        curl_setopt_array($ch, [
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => $create_payload
        ]);
        $create_resp = curl_exec($ch);
        curl_close($ch);
        $create_data = json_decode($create_resp, true);
        if (isset($create_data['success']) && $create_data['success'] === true && !empty($create_data['response'])) {
            $user_id = $create_data['response'];
        }
    }

    if ($user_id) {
        $conversation_id = null;
        $get_conv_payload = [
            'token' => $sb_token,
            'function' => 'get-user-conversations',
            'user_id' => $user_id
        ];
        $ch = curl_init($sb_api_url);
        curl_setopt_array($ch, [
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => $get_conv_payload
        ]);
        $get_conv_resp = curl_exec($ch);
        curl_close($ch);
        $get_conv_data = json_decode($get_conv_resp, true);
        if (!empty($get_conv_data['response']) && is_array($get_conv_data['response'])) {
            foreach ($get_conv_data['response'] as $conversation) {
                if ($conversation['conversation_status_code'] < 3 && ($conversation['source'] ?? '') == 'wa') { 
                    $conversation_id = $conversation['conversation_id']; 
                    break; 
                }
            }
        }
        if (!$conversation_id) {
            $new_conv_payload = [
                'token' => $sb_token,
                'function' => 'new-conversation',
                'user_id' => $user_id,
                'source' => 'wa'
            ];
            $ch = curl_init($sb_api_url);
            curl_setopt_array($ch, [
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_POST => true,
                CURLOPT_POSTFIELDS => $new_conv_payload
            ]);
            $new_conv_resp = curl_exec($ch);
            curl_close($ch);
            $new_conv_data = json_decode($new_conv_resp, true);
            $conversation_id = $new_conv_data['response']['details']['id'] ?? null;
        }
        if ($conversation_id) {
            $send_msg_payload = [
                'token' => $sb_token,
                'function' => 'send-message',
                'user_id' => $user_id,
                'conversation_id' => $conversation_id,
                'message' => $message_text
            ];
            $ch = curl_init($sb_api_url);
            curl_setopt_array($ch, [
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_POST => true,
                CURLOPT_POSTFIELDS => $send_msg_payload
            ]);
            curl_exec($ch);
            curl_close($ch);
        }
    }
    http_response_code(200); exit;
}

// ======================================================================
// 2️⃣ إرسال رسالة من Support Board → YCloud
// ======================================================================
if (isset($data['function']) && $data['function'] === 'message-sent' && $data['key'] === $secret_key) {
    $source = $data['data']['conversation_source'] ?? '';
    if ($source !== 'wa') { http_response_code(200); exit; }

    $msg = $data['data']['message'] ?? '';
    $customer_user_id = $data['data']['conversation_user_id'] ?? null; 
    $admin_user_id = $data['data']['user_id'] ?? null;

    if (!empty($msg) && !empty($customer_user_id) && $customer_user_id != $admin_user_id) {
        $get_extra_payload = [
            'token' => $sb_token,
            'function' => 'get-user-extra',
            'user_id' => $customer_user_id
        ];
        $ch = curl_init($sb_api_url);
        curl_setopt_array($ch, [
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => $get_extra_payload
        ]);
        $user_extra_resp = curl_exec($ch);
        curl_close($ch);
        $user_extra_data = json_decode($user_extra_resp, true);
        $extra_fields = $user_extra_data['response'] ?? [];
        $customer_whatsapp_number = null;
        if (is_array($extra_fields)) {
            foreach ($extra_fields as $field) {
                if (isset($field['slug']) && $field['slug'] == 'phone') { 
                    $customer_whatsapp_number = $field['value']; 
                    break; 
                }
            }
        }

        if ($customer_whatsapp_number) {

            // ✅ إعداد رسالة YCloud
            $ycloud_url = "https://api.ycloud.com/v2/messages";

            // 1️⃣ محاولة الإرسال كنص عادي
            $ycloud_body = [
                "channel" => "whatsapp",
                "from" => $ycloud_from,
                "to" => $customer_whatsapp_number,
                "type" => "whatsapp_text",
                "whatsapp_text" => [
                    "body" => $msg
                ]
            ];
            log_ycloud('SENDING TO YCLOUD (TEXT TRY)', $ycloud_body);

            $ch = curl_init($ycloud_url);
            curl_setopt_array($ch, [
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_HTTPHEADER => [
                    "X-API-Key: $ycloud_token",
                    "Content-Type: application/json"
                ],
                CURLOPT_POST => true,
                CURLOPT_POSTFIELDS => json_encode($ycloud_body, JSON_UNESCAPED_UNICODE)
            ]);
            $ycloud_response = curl_exec($ch);
            $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);

            // 2️⃣ لو فشل الإرسال، نحاول كقالب Template
            if ($httpcode >= 400) {
                log_ycloud("TEXT FAILED (HTTP $httpcode)", $ycloud_response);

                $template_body = [
                    "channel" => "whatsapp",
                    "from" => $ycloud_from,
                    "to" => $customer_whatsapp_number,
                    "type" => "whatsapp_template",
                    "whatsapp_template" => [
                        "name" => "template_utility_20251013212559", // ← غيّر الاسم لو عندك قالب مختلف
                        "language" => ["code" => "en"], // ← غيّرها لو القالب بالعربية
                        "components" => [[
                            "type" => "body",
                            "parameters" => [[
                                "type" => "text",
                                "text" => $msg
                            ]]
                        ]]
                    ]
                ];

                log_ycloud('RETRY AS TEMPLATE', $template_body);

                $ch = curl_init($ycloud_url);
                curl_setopt_array($ch, [
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_HTTPHEADER => [
                        "X-API-Key: $ycloud_token",
                        "Content-Type: application/json"
                    ],
                    CURLOPT_POST => true,
                    CURLOPT_POSTFIELDS => json_encode($template_body, JSON_UNESCAPED_UNICODE)
                ]);
                $ycloud_response = curl_exec($ch);
                $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
                curl_close($ch);
            }

            log_ycloud("FINAL YCLOUD RESPONSE (HTTP $httpcode)", $ycloud_response);

        } else {
            log_ycloud('ERROR: CANNOT SEND', "Could not find 'phone' field for User ID: $customer_user_id.", $user_extra_resp);
        }
    }
    http_response_code(200); exit;
}

http_response_code(200);
echo json_encode(['status' => 'ignored']);
?>
