<?php
require('include/functions.php');

// Simulate enabling the setting
$current_setting = sb_get_setting('open-ai');
$current_setting['open-ai-vision'] = true;
// We can't easily mock sb_get_setting without writing to DB, so we'll just check if the function works assuming the setting is ON.
// Actually, we can temporarily update the global $SB_SETTINGS if the function uses it? 
// sb_get_setting pulls from DB or cache.

// Let's just try calling the function. If it returns false because of the setting, we'll know.
// But to test it properly, we might need to bypass the check or write to DB.
// Let's try to set the setting via DB for this test and revert it.

if (!sb_get_setting('open-ai-vision')) {
    echo "Vision setting is OFF. Temporarily enabling it...\n";
    sb_save_setting('open-ai-vision', true); // This might be saved as a separate setting or part of the 'open-ai' array. 
    // The code checks sb_get_setting('open-ai-vision') which usually implies a top level setting or a key. 
    // In functions.php: $settings = sb_get_setting('open-ai'); if (!sb_isset($settings, 'open-ai-vision')) ...
    // So it expects 'open-ai' setting to be an array containing 'open-ai-vision'.
    
    $settings = sb_get_setting('open-ai');
    if (!is_array($settings)) $settings = [];
    $settings['open-ai-vision'] = true;
    sb_save_setting('open-ai', $settings);
    $revert = true;
} else {
    $revert = false;
    echo "Vision setting is already ON.\n";
}

$url = 'https://upload.wikimedia.org/wikipedia/commons/4/47/PNG_transparency_demonstration_1.png'; // Simple dice image
echo "Testing URL: " . $url . "\n";

$text = sb_open_ai_image_to_text($url);

echo "Result: " . ($text ? $text : "FALSE (Check settings or API key)") . "\n";

if ($revert) {
    echo "Reverting setting...\n";
    $settings['open-ai-vision'] = false; // Or unset
    sb_save_setting('open-ai', $settings);
}

?>
