<?php
require_once('include/functions.php');
require_once('apps/dialogflow/functions.php');

$flows = sb_flows_get();
$target_flow_name = 'usmle_copy';
$flow_found = false;
$modified = false;

// Long triggers to remove
$to_remove = [
    'أهلاً بحضرتك يا دكتور ، اضغط على "الأسئلة الشائعة" وهيظهر لحضرتك أهم الأسئلة ، ولو فيه أي أسئلة أخرى ابعتلنا يا دكتور وهنجاوب حضرتك بأسرع وقت',
    "أهلاً بحضرتك يا دكتور ، اضغط على 'الأسئلة الشائعة' وهيظهر لحضرتك أهم الأسئلة ، ولو فيه أي أسئلة أخرى ابعتلنا يا دكتور وهنجاوب حضرتك بأسرع وقت",
    'أهلاً بحضرتك يا دكتور ، اضغط على " الأسئلة الشائعة " وهيظهر لحضرتك أهم الأسئلة ، ولو فيه أي أسئلة أخرى ابعتلنا يا دكتور وهنجاوب حضرتك بأسرع وقت',
    'أهلاً بحضرتك يا دكتور ، اضغط على "الأسئلة الشائعة " وهيظهر لحضرتك أهم الأسئلة ، ولو فيه أي أسئلة أخرى ابعتلنا يا دكتور وهنجاوب حضرتك بأسرع وقت'
];

// Short triggers to add (Robust)
// Note: Code uses strpos, so these just need to be present in the user message.
$to_add = [
    'اضغط على "الأسئلة الشائعة"',
    "اضغط على 'الأسئلة الشائعة'",
    "اضغط على \" الأسئلة الشائعة \"",
    "اضغط على ' الأسئلة الشائعة '"
];

foreach ($flows as &$flow) {
    if ($flow['name'] === $target_flow_name) {
        $flow_found = true;
        $triggers = &$flow['steps'][0][0][0];
        
        if (!isset($triggers['message'])) {
            $triggers['message'] = [];
        }

        // 1. Remove old long ones
        $new_messages = [];
        foreach ($triggers['message'] as $msg) {
            if (!in_array($msg['message'], $to_remove)) {
                $new_messages[] = $msg;
            } else {
                echo "Removing rigid trigger: " . substr($msg['message'], 0, 30) . "...\n";
                $modified = true;
            }
        }
        $triggers['message'] = $new_messages;

        // 2. Add new short ones
        $existing_texts = array_column($triggers['message'], 'message');
        foreach ($to_add as $add) {
            if (!in_array($add, $existing_texts)) {
                $triggers['message'][] = ['message' => $add];
                echo "Adding robust trigger: " . $add . "\n";
                $modified = true;
            }
        }
        
        break;
    }
}

if ($flow_found && $modified) {
    $result = sb_flows_save(json_encode($flows, JSON_UNESCAPED_UNICODE));
    echo "Save result: " . ($result === true ? "Success" : json_encode($result)) . "\n";
} else {
    echo "No changes needed or flow not found.\n";
}
?>
